BEGIN {
      
  eval { require 5.8.0; };
    if( $@ ) {
      print "1..0 # Skip: perl 5.8.0 or newer required\n";
      exit (0);
  }
    
}

use strict;
use ReDIF::Parser qw( &redif_open_file
                      &redif_get_next_template
                      &redif_set_parser_options );

redif_set_parser_options ( 'utf8_output' => 1 );

my $file = redif_open_file( "t/montde.2003.mont.rdf" );


my $t;

while ( $t = redif_get_next_template() ) {
  if ( $t ->{handle}[0] eq 'RePEc:mtl:montde:2003-11' ) {
    last;
  }
}

if ( $t ) {
   ### now the test

   print "1..1\n";

   my $res = '';

   my $title = $t ->{title}[0];
   
   if ( $title =~ m/([\x80-\x9F])/ ) {
     ### forbidden character(s)!
     $res = '%' . sprintf( "%X", ord( $1 ) );
     print "not ok 1\n";
   } else {
     print "ok 1\n";
   }    

   binmode( STDOUT, ":utf8" );
   print "Title: $title\n";
   print "Result: $res\n";
}

