### -*- Mode: perl -*-

use lib qw( ./lib );

use ReDIF::Testing;

eval " require ReDIF::URL_Syntax; ";

if( $@ ) {
    nok ( $@ );
} else {
    ok ();
}

sub test_url {
    my $url = shift;
    my $expect = shift;

    my $result;
    my $check = &ReDIF::URL_Syntax::check_url( $url ) ;

    if( not defined $check ) {
	$result = "'$url' is bad" ;
    } else {
	$result = "'$url' is ok ('$check')" ;
    }

    if( $expect ) {
	if( defined $check and ( $check eq $expect ) ) {
	    ok( "got: $result as expected" );
	} else {
	    nok ( "got: $result, expected: ok, '$expect'" );
	}

    } else {
	if( defined $check ) {
	    nok ( "got: $result, expected: bad" );
	} else {
	    ok( "got: $result as expected" );
	}
    }

}


while( <DATA> ) {
    chomp;
    my $url = $_;
    my $expect = <DATA>;
    last if( not defined $expect );
    chomp $expect;
    
    test_url( $url, $expect );

};


###
###  Here in the DATA block each pair of lines is a test.  First line
###  in the pair is what should be checked, the second line is what
###  should be returned from the check_url() function.  If the second
###  line is empty, then the check_url() should report bad URL.
###

__DATA__
htt://url1

abracadabara

http://netec.mcc.ac.uk
http://netec.mcc.ac.uk
htTp://netec.mcc.ac.uk
http://netec.mcc.ac.uk
http://netec.mcc- .ac.uk

http://netec.mcc .ac.uk
http://netec.mcc.ac.uk
URL:http://netec.mcc.ac.uk
http://netec.mcc.ac.uk
http://netec.mcc-.ac.uk

http://netec.mcc.ac.uk:90
http://netec.mcc.ac.uk:90
http://netec.mcc.ac.uk:WORD

http://netec.mcc.ac.uk.20

Ftp://ivan@netec.mcc.ac.uk
ftp://ivan@netec.mcc.ac.uk
ftp://iv_an@netec.mcc.ac.uk
ftp://iv_an@netec.mcc.ac.uk
ftp://ivan:_cool@netec.mcc.ac.uk
ftp://ivan:_cool@netec.mcc.ac.uk
ftp://ivan?@netec.mcc.ac.uk
ftp://ivan?@netec.mcc.ac.uk
ftp://ivan/@netec.mcc.ac.uk

http://www.bepress.com/cgi/viewpdf.cgi?artic1e=1030&amp;context=jm&amp;preview_mode=
http://www.bepress.com/cgi/viewpdf.cgi?artic1e=1030&amp;context=jm&amp;preview_mode=
http://www.rich.frb.org/regionfocus/spring98/index.html#fazio
http://www.rich.frb.org/regionfocus/spring98/index.html#fazio
http://www.catchword.com/cgi-bin/cgi?ini=bc&body=linker&reqidx=1364-8594(19990101)93:1L.3;1-
http://www.catchword.com/cgi-bin/cgi?ini=bc&body=linker&reqidx=1364-8594(19990101)93:1L.3;1-
ftp://netec.mcc.ac.uk/~adnetec/
ftp://netec.mcc.ac.uk/~adnetec/
