### -*- Mode: perl -*-

eval " use ReDIF::Parser::Output; ";

test( not( $@ ), $@ );

use ReDIF::Parser::Output;

my $BUF = ReDIF::Parser::Output -> new( mode => 'checker', 
				    quote_data => '> ',
				    threshold => 3 );

test( defined $BUF );

test( defined $BUF->{threshold} 
      and ( $BUF->{threshold}== 3 ) , 
      "THRESHOLD: < $BUF->{threshold} >"
      );

$BUF->add_data( "some basic data" );

$BUF->add_data( "some more basic data" );
$BUF->error( "a testing message -- error" );
$BUF->add_data( "some more data after an error" );


my $output = $BUF->get_text();
#print '[', $#TESTS+2 , '] ', $output, "\n";

test( scalar( $output =~ /^some more basic data$/m ) , $output );

test( $output =~ /\nError a testing message/ );
test( $output =~ /-- error\n+$/ );



###############################################################
#############     TESTING   FRAMEWORK     #####################
###############################################################

sub test {
    push @TESTS, shift;
    push @MESSAGES, shift;
}

sub ok { 
    push @TESTS, 1; 
    push @MESSAGES, shift;
}
sub nok { 
    push @TESTS, 0; 
    push @MESSAGES, shift;
}



END { 

    my $tests = scalar @TESTS;

    if( not $tests ) {
	print "1..1\nnot ok 1\n";
	exit;
    }

    print "1..$tests\n";

    my $counter = 1;
    while ( 1 ) {
	my $t = shift @TESTS;
	my $m = shift @MESSAGES;
	if( not $t ) {
	    print "not ";
	}
	print "ok $counter\n";

	if( $m ) { 
	    print "[$counter] $m\n";
	}
	last if not scalar @TESTS;
	$counter ++;
    }
}
