##  ReDIF::Spec first test script:
##
##

BEGIN {print "1..11\n";}
END {print "not ok 1\n" unless $loaded;}

use ReDIF::Spec;

$loaded = 1;

print "ok 1\n";

my $redif_spec = 'lib/ReDIF/redif.spec';

my $spec = ReDIF::Spec -> new( $redif_spec );

if ( defined $spec ) { print "ok 2\n"; }
else                 { print "not ok 2\n"; exit; }

my $spec_ok = $spec -> ok();

if ( defined $spec_ok ) { print "ok 3\n"; }
else                    { print "not ok 3\n"; }


my $a_context = $spec -> context( 'erunda' ); 

if ( not defined $a_context ) { print "ok 4\n"; }
else                          { print "not ok 4\n"; }

$a_context = $spec -> context( 'person' ); 

if ( ref( $a_context) eq 'HASH' ) { print "ok 5\n"; }
else                              { print "not ok 5\n"; }


$a_type = $spec -> type( 'url' ); 

if ( ref( $a_type ) eq 'HASH' ) { print "ok 6\n"; }
else                            { print "not ok 6\n"; }


$a_tt = $spec -> template_type_id( 'redif-paper 1.0' ); 
$tt_cont = $spec->context( $a_tt );

if ( ref( $tt_cont ) eq 'HASH' ) { print "ok 7\n"; }
else {  
        print "not ok 7\n"; 
#       print join ' ', keys %{$spec->{templates}};
        print $a_tt, ' ', ref $a_tt;
        }

{
  my $hash = $spec -> {attribute_list} ;
  my @list = keys %$hash;

  if( scalar @list < 10 ) {
    print 'attribute list: ', join( ' ', @list) , "\n";
    print 'attribute hash: ', ref $hash, "\n";
    print "not ";
  }
  print "ok 8\n";
  
  
  my $descr = $spec->{attribute_list}->{'programming-language'};
  if( not defined ($descr) or ($descr !~ /software/i) ) {
    print "bad description: $descr\n" unless not defined $descr;
    print "not ";
  }
  print "ok 9\n";
  
  use pretty_print qw( &pretty_print );
#  pretty_print ( $spec->{attribute_list} );
  pretty_print ( $spec );

}


### context postprocessing rules test

my $context = $spec->context( 'template2' );

if( not defined $context->{POSTPROC} ) { 
    print "not ";
} 

print "ok 10\n";


if( not defined( $context->{POST_RULES} ) 
    or ref( $context->{POST_RULES} ) ne 'ARRAY' ) { 
    print "not ";
} 

print "ok 11\n";





