### -*- Mode: perl -*-

sub test( $;$ );

eval " use ReDIF::Record; ";

test not( $@ ), $@ ;

use ReDIF::Record;

{
  # ftrain is the id, website is type
  my $r = ReDIF::Record->new( 'ftrain', "website" );

  test( $r );

  $r -> add_property ( "title",       "Ftrain.com" );
  $r -> add_property ( "description", "Personal website of Paul Ford" );

  test $r->type;
  test $r->id  ;

  test $r -> {title} ;  
  test ref( $r -> {title} ) eq 'ARRAY' ;  
  test scalar @{ $r -> {title} } ;  
  test scalar( @{ $r -> {title} } ) == 1 ;  
  test $r -> {title} -> [0] ;  

  test $r -> {description} ;  
  test ref( $r -> {description} ) eq 'ARRAY' ;  
  test scalar @{ $r -> {description} } ;  
  test $r -> {description} -> [0] ;  

}
 
use ReDIF::Parser qw( &redif_open_file &redif_get_next_template );


test redif_open_file( 't/1995.rdf' );

my $r = redif_get_next_template();

test $r;

bless $r, ReDIF::Record;

test $r->type;
test $r->id;

my @v;

@v = $r -> get_value( 'title' );
test scalar @v;
test $v[0];
test $v[0] =~ /Neoclassical/;


@v = $r -> get_value( 'author/workplace/name' );
test scalar @v;
test scalar @v == 2;
test $v[0], $v[0];
test $v[0] =~ /bec /;  # part of "Qubec  Montral"

test $v[1], $v[1];
test $v[1] =~ /Ontario/;  


@v = $r -> get_value( 'author' );
test scalar @v;
test scalar @v == 2;
test $v[0];
test ref $v[0] eq 'HASH';  # an author cluster
test $v[0]->{name};
test $v[0]->{name}->[0];




if( 0 ) {
$r = redif_open_file( 't/names_test.rdf' );
$t = redif_get_next_template();

my $authors = $t->{author};

test( scalar( @$authors ) == 2 );

my $h = $t->{handle};

test( (scalar( @$h ) == 1 ) , $h->[0] );

test( $h->[0] );

my $tt = $t->{'template-type'};

test( (scalar( @$tt ) == 1 ) , $tt->[0] );

}


###############################################################
#############     TESTING   FRAMEWORK     #####################
###############################################################

sub test ($;$)  {
    push @TESTS, shift;
    push @MESSAGES, shift;
}

sub ok { 
    push @TESTS, 1; 
    push @MESSAGES, shift;
}
sub nok { 
    push @TESTS, 0; 
    push @MESSAGES, shift;
}



END { 

    my $tests = scalar @TESTS;

    if( not $tests ) {
	print "1..1\nnot ok 1\n";
	exit;
    }

    print "1..$tests\n";

    my $counter = 1;
    while ( 1 ) {
	my $t = shift @TESTS;
	my $m = shift @MESSAGES;
	if( not $t ) {
	    print "not ";
	}
	print "ok $counter\n";

	if( $m ) { 
	    print "[$counter] $m\n";
	}
	last if not scalar @TESTS;
	$counter ++;
    }
}


__END__

##  
##



BEGIN {print "1..7\n";}
END {print "not ok 1\n" unless $loaded;}

use ReDIF::Record;

$loaded = 1;

print "ok 1\n";

{
    my $template = ReDIF::Record -> new( -type => 'ReDIF-Person 1.0' );

    print "ok 2\n";
    
    $template -> add_property( "title", "The Paper" );
    $template -> add_property( "handle", "RePEc:wop:aarhec:94-01" );
    $template -> open_structured_property( "author", "person cluster" );

    use pretty_print;
    pretty_print( $template );

    $template -> add_property( "name", "Bob Dylan" );
    $template -> close_structured_property( );
    $template -> add_property( "abstract", "very good paper" );


    my $t_hash = $template -> as_hash();
    
    if( sprintf ($t_hash) !~ /=HASH/ ) {
	print "ref ($t_hash) = " , ref $t_hash, "\n";
	print "not ";
    }
    print "ok 3\n";

    if( $t_hash -> {title} -> [0] ne 'The Paper' ) {
	print "not ";
    }	
    print "ok 4\n";
    
    if( $t_hash -> {handle} -> [0] ne 'RePEc:wop:aarhec:94-01' ) {
	print "not ";
    }	
    print "ok 5\n";

    if( not defined ( $t_hash -> {author} -> [0] ) ) {
 	print "undefined `author[0]'!\n";
	print "not ";
    } elsif( $t_hash -> {author} -> [0] -> {name} -> [0] ne 'Bob Dylan' ) {
	use pretty_print qw( &pretty_print );
	pretty_print( $t_hash );
	print "not ";
    }	
    print "ok 6\n";
    
    if( $t_hash -> {abstract} -> [0] ne 'very good paper' ) {
	use pretty_print qw( &pretty_print );
	pretty_print( $t_hash );
	print "not ";
    }	
    print "ok 7\n";
    
    
}



