### -*- Mode: perl -*-

BEGIN { 
#	push @ARGV, '--spec' , './spec'; 
}

sub test ($;$);

use ReDIF::Parser;
my $t;

$t = ReDIF::Parser::open_file( "t/1996.rdf" );

test( $t, "open_file" );

$t = ReDIF::Parser::get_next_template () ;

test( $t, "get_next_template" );

test ( $t -> {handle} [0] eq 'RePEc:cri:uqimwp:9609' ) ;

test $t -> {file}[0]{format}[0] eq 'application/x-flash' ;

# print "type: ", $t -> {file}[0]{format}[0], "\n";

$t = ReDIF::Parser::get_next_template_good_or_bad () ;

test not defined $t -> {file}[0]{format}[0];
# print "type: ", $t -> {file}[0]{format}[0], "\n";


$t = ReDIF::Parser::get_next_template_good_or_bad () ;

test $t -> {file}[0]{format}[0] eq 'application/msword' ;
# print "type: ", $t -> {file}[0]{format}[0], "\n";



###############################################################
#############     TESTING   FRAMEWORK     #####################
###############################################################

sub test ($;$) {
    push @TESTS, shift;
    push @MESSAGES, shift;
}

sub ok { 
    push @TESTS, 1; 
    push @MESSAGES, shift;
}
sub nok { 
    push @TESTS, 0; 
    push @MESSAGES, shift;
}



END { 

    my $tests = scalar @TESTS;

    if( not $tests ) {
	print "1..1\nnot ok 1\n";
	exit;
    }

    print "1..$tests\n";

    my $counter = 1;
    while ( 1 ) {
	my $t = shift @TESTS;
	my $m = shift @MESSAGES;
	if( not $t ) {
	    print "not ";
	}
	print "ok $counter\n";

	if( $m ) { 
	    print "[$counter] $m\n";
	}
	last if not scalar @TESTS;
	$counter ++;
    }
}
