### -*- Mode: perl -*-
BEGIN {
  eval { require AMF::Parser; };
  if ( $@ ) {
    print "1..0 # Skip: AMF::Parser required\n";
    exit (0);
  }    
}

use ReDIF::Testing;
use ReDIF::AMF;
use ReDIF::Parser qw( &redif_open_file &redif_get_next_template );


my $r;
my $t;

$r = redif_open_file( 't/test.amf' );

test( $r );

$t = redif_get_next_template();

test( $t );


my $e = $t->{'maintainer-email'};

test( (scalar( @$e ) == 1 ) , $e->[0] );
test( $e->[0] );

my $h = $t->{handle};

test( (scalar( @$h ) == 1 ) , $h->[0] );

test( $h->[0] );

my $tt = $t->{'template-type'};

test( (scalar( @$tt ) == 1 ) , $tt->[0] );



