#####################################################################
##############      ReDIF Specification File     ####################
#####################################################################

version = $Revision: 2.11 $-5.8

###  $Id: redif.spec,v 2.11 2007/02/27 20:53:38 ivan Exp $

###  Since ReDIF-perl version 2.24, there is a change to parsing perl code
###  blocks, like check-eval blocks, for example.  Now they will only be
###  terminated with a closing curly brace in the *first* position of the
###  line, with optional whitespace characters after it, but nothing else on
###  the same line.


# Brief history since 2000
#
# version revised by Thomas Krichel in July 2000
# 
# Book and Chapter templates added by Ivan Kurmanov, Jul 2001
#


###
###  Specifying possible value lengths (for a type):
###       top    - critical high limit, violation will cause an error
###       max    - high limit, violation will cause a warning
###       min    - lower limit, violation will cause a warning
###       bottom - critical lower limit, violation will cause an error

type = TITLE / length {
 top: 1000
 max: 300
 min: 10
 bottom: 3
}

type = NAME / length {
 top: 400
 max: 60
 min: 5
 bottom: 3
}

type = ABSTRACT / length {
 top: 4200
 max: 2600
 min: 100
 bottom: 30
}

type = JEL / length {
 top: 200
 max: 100
}

type = URL / length {
 top: 500
 max: 170
 min: 11
 bottom: 9
}

#   email

type = email / length {
 top: 120
 max: 60
 min: 9
 bottom: 7
}


###  handles:

type = handle / length {
 top: 120
 max: 100
}

type = documenthandle / length {
 top: 120
 max: 100
}

type = personhandle / length {
 top: 120
 max: 100
}

type = postal / length {
 top: 600
 max: 320
}

type = pubstatus / length {
 top: 500
 max: 300
}


type = default_type / length {
 top: 500
 max: 250
}

type = keywords / length {
 top: 1500
 max: 750
}



#  NEW ATTRIBUTE SPECIFICATION LINE FORMAT:
# 
#      attribute[:[type[:subtype]],qualifier[,qualifier[...]] 
# 
#   where qualifier is one of 
#
#    'req' or 'required'  -- the attribute is required, must appear
#                            at least once
#    'norep' or 'nonrep' or 'nonrepeatable' -- the attribute cannot
#                                              be repeated, can appear
#                                              no more that once
#    'key' -- specifies key attribute of a cluster (the attribute that
#             the cluster must begin with).  Implies: required, 
#             nonrepeatable
#
#   NOTE: specification line is letter case and whitespace insignificant
#  

#   OLD ATTRIBUTE SPECIFICATION LINE FORMAT (still accepted):
#
# attribute_name[:[type][:[subtype][:[required flag][:[repeatable flag]]]]]
#


###
### User-defined types (checking procedures)
###


type = programming_language / check-regex {
 ^(?:C|C\+\+|DOS\sexecutable|executable|FORTRAN|GAUSS|Gretl|Java|Mathematica|MATLAB|Octave|Ox|perl|python|R|RATS|Shazam|S\-plus|stata|TSP\sInternational)$
}


###  The following defines a datatype "MIME_type" through
###  preproc-essing aspect.  The following code is executed
###  (eval-uated) each time a value ($value) of type MIME_type has
###  just been read from a datafile.

type = MIME_type / check-eval {

    $value = lc $value;
    ### strip everything after the second slash
    $value =~ s!(^[^/]+/[^/]+)/.*!$1!;  

    if( $value =~ /^(?:application|text|image|audio|video)\/x-[\w\-\.]+$/i ) { return 1; }

#    ### save the value 
#    my $v = $value;           

#    ### try loading the types list module

    eval { require( ReDIF::MIME_types ) }; 
    my $error = $@;

    if ($error) { 
	warn "can't load ReDIF::MIME_types module";
	return undef;
    };

#    msg( "MIME types badly loaded", 3 ) 
#          if not $ReDIF::MIME_types::LIST{'application/pdf'};

    my $ok = 0;

    ### check the MIME type
    if ( $ReDIF::MIME_types::LIST{$value} ) { 
      $ok = 1;
    };

    if ( not $ok ) {   
	error( "Invalid MIME-type used: '$value'" ) ;
    };

    return 1;
}


##
## Handles checking regular expression 
##
type = handle / check-regex {
^[A-Za-z]+\:[a-zA-Z]+(?:\:[a-zA-Z0-9]+(?:\:[^\s\n]+)?)?$
}

##
## 
##
type = archivehandle / check-eval {
    $value =~ tr/A-Z/a-z/;
    $value =~ s/^RePEc/RePEc/i;
    $value =~ s/^ReLIS/ReLIS/i;
    if( $value =~ m/^(?:RePEc|ReLIS|mapin):[a-zA-Z]{3}$/i ) 
    { return 1; } else { return 0; } 
}

# documenthandle to be used for paper, article and software
type = documenthandle / check-eval {
    $value =~ tr/A-Z/a-z/;
    $value =~ s/^RePEc/RePEc/i;
    $value =~ s/^ReLIS/ReLIS/i;
    if ( $value =~ 
   m/^(?:RePEc|ReLIS|mapin):[a-z]{3}:[a-z\d]{6}:[^\s|\^\$\[\]\#\;\x00-\x1f\x80-\x{FFFF}]+$/i ) 
    { return 1; } else { return 0; }    
}

#
type = institutionhandle / check-eval {
    $value =~ tr/A-Z/a-z/;
    $value =~ s/^RePEc/RePEc/i;
    $value =~ s/^ReLIS/ReLIS/i;
    if( $value =~ m/^(?:RePEc|ReLIS|mapin):[a-z]{3}:[a-z\d]{7}$/i ) 
     { return 1; } else { return 0; }
}


type = personhandle / check-eval {
###    $value =~ tr/A-Z/a-z/;  ## No case normalization for Person template handles
    if ( $value =~ /^p[a-z]+\d+$/i ) {   ### person short-id
       $value = lc $value; 
       return 1;  
    ;} ###
    $value =~ s/^RePEc/RePEc/i;
    $value =~ s/^ReLIS/ReLIS/i;
    if ( $value =~ m/^(RePEc|ReLIS|mapin)(:[a-z]{3}:\d{4}-[01]\d-[0-3]\d)(:[a-z\d\_\.\-]+)$/i ) 
    { # my $nothing = $3; $value = "$1$2\U$3"; 
                ###  \U means turn to uppercase as in uc ()
	        ###  but may cause real problems by mutating the string
      my $three = uc $3; $value = "$1$2$three"; 
    return 1; } else { return 0; }
}


type = serieshandle / check-eval {
    $value =~ tr/A-Z/a-z/;
    $value =~ s/^RePEc/RePEc/i;
    $value =~ s/^ReLIS/ReLIS/i;
    if( $value =~ m/^(?:RePEc|ReLIS|mapin):[a-z]{3}:[a-z\d]{6}$/i ) 
    {  return 1; } else { return 0; }
}


##
## all non-handle types, ordered alphabetically 
##

type = date / check-eval {
     if ($value !~ /-/ ) {
        $value =~ s/^(\d{4})(\d{2})$/$1-$2/;
        $value =~ s/^(\d{4})(\d{2})(\d{2})/$1-$2-$3/; 
    }
    
    return 1 if $value =~ /^\d{4}(-\d\d){0,2}$/;
    return 0;
}

type = email / check-regex {
^[\&\+a-z\d\-\.\=\_]+\@[a-z\d\-\.\=\_]+\.[a-z\d\.\-\=]+$
}


### this is now obsolete

type = fileformat / check-regex {
^(?:\w+)(?:/\w+)?$
}

type = JEL / check-eval {

#     if ( $value !~ /[a-z][\d]{0,3}/i ){ return undef; }
     if ( not require ReDIF::JELcodes )   {
         warn "can't load JEL codes perl module";
	 return undef;     }

     if( $value =~ /^\d{3}(?:[,;:\s\.]+\d{3})*$/ ) {
	$value = ''; return 1; 
     };

     my $v = uc $value ;
     my @J = split ( /[,;:\s\.]+/, $v );

     $value = '';
     foreach (@J) {
	if( /^([A-Z]\d{2})0$/ ) { $_ = $1; }
        if (exists $ReDIF::JELcodes::JEL{$_}) {
           $value .= "$_ ";
        } else {
	   warning( "An invalid JEL code used '$_'" );
     } }
     chop $value; return length $value;
}


# ISO 639-1 Language code
type = LangCode639_1 / check-eval {
    if ( not require ReDIF::Language::Codes6391 ) {
        warn "can't load ReDIF::Language::Codes6391 module";
        return undef;
    };
    if ( $value !~ m/^[a-z]{2}$/i 
         or not $ReDIF::Language::Codes6391::Codes->{lc $value} ) {
        warning( "An invalid language code: $value" ); 
        $value=''; } 
    else { $value = lc $value; }
    return 1;
}

# publication status type implements Sune's requirement that the
# first word in the publication status should be either "published" or
# "forthcoming"
type = pubstat / check-regex  {
 ^(?:forthcoming|published)
}


# URL datatype

type = URL / check-eval {

#    require ReDIF::Parser;
    use ReDIF::URL_Syntax;

    my $v = &ReDIF::URL_Syntax::check_url( $value );
    if( not defined $v ) {
	return 0;
    } else {
	$value = $v;
	return 1;
    }
}



type = doctype / check-eval {
    if ( $value ) {
	  if ( $value =~
	    /^ReDIF-(paper|article|software|book|chapter|person|institution)\b/i ) {
		  $value = "ReDIF-" . ucfirst $1;
		  return 1;
	  } else { return 0; };
    } else { $value = "ReDIF-Paper"; return 1; }
}


###  The following have been used for UPS proto-proto:

###  (in conjunction with ReDIF/math_class_msc1991.pm file it provides
###  checking for the mathematics classification codes of MSC1991 system)

type = MSC1991 / check-eval {

     my $v = uc $value ;
     my @C = split ( /[,;:\s\.]+/, $v );

     eval { require ReDIF::math_class_msc1991 };
     my $error = $@;

     if ( $error ) {
        warn "can't load ReDIF/math_class_msc1991.pm file";    
	return undef;
     };

     $value = '';
     my $C;
     foreach $C (@C) {
          if (exists $msc1991{$C}) {
             $value .= $C;
             $value .= ' ';
          } else {
             error( "An invalid MSC1991 code used: '$C'" );    
     } }
     chop $value; return length $value;
}




###
### Cluster definitions
###

###  File cluster definition:  (now with file-format attribute of MIME type)

cluster=File {
        URL:URL, key
        Format:MIME_type
        Function, nonrep
        Size
        Restriction
}



Cluster=Organization {
        Name:TITLE, key
        Homepage:URL
        Name-English
        Postal:postal
        Location
        Email:email
        Phone
        Fax
        Institution:institutionhandle, nonrep	
}

Cluster=Person {
        Name:NAME, key
	Name-First
	Name-Last
        Homepage:URL
        WorkPlace:cluster:Organization
        Email:email
        Fax
        Postal:postal
        Phone
        Person:personhandle, nonrepeatable
}

###
### Template-types definition 
###

##
## Collection templates
##

template=ReDIF-Archive 1.0 {
        Template-Type, key
        Handle:archivehandle, required, nonrepeatable
        URL:URL, required
        Maintainer-Email:email, required
        Name:TITLE, required
        Maintainer-Name
        Maintainer-Phone
        Maintainer-Fax

	Classification-ACM-1964,nonrep
	Classification-ACM-1991,nonrep
	Classification-ACM-1998,nonrep
	Classification-Ila,nonrep
        Classification-Jel:JEL,nonrep
	Classification-MSC-1991:MSC1991,nonrep
	Classification-MSC-2000,nonrep

        Homepage:URL
        Description:TITLE
	Notification
        Restriction
}


template=ReDIF-Series 1.0 {
        Template-Type, key
        Name:TITLE, required
        Handle:serieshandle, required, nonrepeatable
        Maintainer-Email:email, required
        type:doctype

        Order-Email:email
        Order-Homepage:URL
        Order-Postal:postal
        Price
        Provider:cluster:organization
        Restriction
        Maintainer-Phone
        Maintainer-Fax
        Maintainer-Name

        Description:TITLE

        Classification-ACM-1964,nonrep
	Classification-ACM-1991,nonrep
	Classification-ACM-1998,nonrep
	Classification-Ila,nonrep
        Classification-Jel:JEL,nonrep
	Classification-MSC-1991:MSC1991,nonrep
	Classification-MSC-2000,nonrep

        Keywords:keywords
	Keywords-Attent:keywords

        Editor:cluster:Person

        Notification
        ISSN
	Followup
	Predecessor

        # deprecated, and should be post-process converted to provider-(org*) 
        Publisher:cluster:organization, deprec

        # deprecated, but still accepted (shall be deleted after a short while)
        Provider-Institution:institutionhandle, deprec
}

postproc = ReDIF-Series 1.0 {  
    ### move all publisher-* to provider- cluster
    my $provider = $object -> {provider} || [];
    if ( $object->{publisher} ) {
      my @publisher = ( @{ $object->{publisher} } );
      foreach ( @publisher ) {
        push @$provider, $_;
      }
      delete $object->{publisher};
    }
    if ( scalar @$provider ) {
      $object->{provider} = $provider;
    } else {
    #      error "Provider organization cluster is required";
    }
}




##
## Resource templates
##

template=ReDIF-Paper 1.0 {
        Template-Type, key
        Title:TITLE, req, nonrep
        Author:cluster:Person, required
        Handle:documenthandle, req, nonrep
        Language:LangCode639_1
        Contact-Email:email, nonrep

        Abstract:ABSTRACT
        File:cluster:file

        Classification-ACM-1964,nonrep
	Classification-ACM-1991,nonrep
	Classification-ACM-1998,nonrep
	Classification-Ila,nonrep
        Classification-Jel:JEL,nonrep
	Classification-MSC-1991:MSC1991,nonrep
	Classification-MSC-2000,nonrep

        Keywords:keywords
        Keywords-Attent:keywords

        Number
        Creation-Date:date, nonrep
        Revision-Date:date
        Publication-Status:pubstat

        Note
        Length
        Series
        Availability
        Order-URL:URL

        Article-Handle:documenthandle
        Book-Handle:documenthandle
        Chapter-Handle:documenthandle
        Paper-Handle:documenthandle
        Software-Handle:documenthandle

        Restriction
        Price
	Notification
}


template=ReDIF-Article 1.0 {
        Template-Type, key
        Handle:documenthandle, required, nonrep
        Language:LangCode639_1

        Journal
        Volume
        Year
        Issue
        Month
        Pages
        Number:nonrep

        Article-Handle:documenthandle
        Book-Handle:documenthandle
        Chapter-Handle:documenthandle
        Paper-Handle:documenthandle
        Software-Handle:documenthandle

        # attributes from the ReDIF-paper template
        Title:TITLE, req, nonrep
        Author:cluster:Person, required
        Contact-Email:email, nonrep

        Abstract:ABSTRACT
        File:cluster:file

        Classification-ACM-1964,nonrep
	Classification-ACM-1991,nonrep
	Classification-ACM-1998,nonrep
	Classification-Ila,nonrep
        Classification-Jel:JEL,nonrep
	Classification-MSC-1991:MSC1991,nonrep
	Classification-MSC-2000,nonrep

        Keywords:keywords
        Keywords-Attent:keywords

        Creation-Date:date, nonrep
        Publication-Status:pubstat

        Order-URL:URL

        Restriction
	Notification
	Price 
        Note
        publication-date:date, deprec
}

postproc = ReDIF-Article 1.0 {  
    ### map publication-date to creation-date
    my $credate = $object -> {'creation-date'} || [];
    if ( my $pubdate = $object->{'publication-date'} ) {
      foreach ( @$pubdate ) {
        push @$credate, $_;
      }
      delete $object->{'publication-date'};
      $object->{'creation-date'} = $credate;
    }

}


template=ReDIF-Software 1.0 {
        Template-Type, key
        Handle:documenthandle, required,nonrep
        Title:TITLE, req, nonrep
        Programming-Language:programming_language::
        File:cluster:file

        Author:cluster:Person, req
        Abstract:ABSTRACT
        Number
	Version
        Keywords:keywords
        Size
        Series
        Creation-Date:date, nonrep
        Revision-Date:date
        Note
        Requires

        Classification-ACM-1964,nonrep
	Classification-ACM-1991,nonrep
	Classification-ACM-1998,nonrep
	Classification-Ila,nonrep
        Classification-Jel:JEL,nonrep
	Classification-MSC-1991:MSC1991,nonrep
	Classification-MSC-2000,nonrep

        Article-Handle:documenthandle
        Book-Handle:documenthandle
        Chapter-Handle:documenthandle
        Paper-Handle:documenthandle
        Software-Handle:documenthandle

        price,deprec
        length,deprec
        contact-email,deprec
}

##
##  Book and chapter template types
##

template=ReDIF-Book 1.0 {
        Template-Type, key
        Title:TITLE, required, nonrepeatable
        Handle:documenthandle, required, nonrep
        Author:cluster:Person
	Provider:cluster:Organization

        Language:LangCode639_1
        Contact-Email:email, nonrep
        Year:   nonrep
        Month:  nonrep
        Volume: nonrep
        Edition: nonrep
        Series: nonrep
	Editor:cluster:Person
 	ISBN,   nonrep
	Publication-Status:pubstat
        Note
        Abstract:ABSTRACT

        Classification-ACM-1964,nonrep
	Classification-ACM-1991,nonrep
	Classification-ACM-1998,nonrep
	Classification-Ila,nonrep
        Classification-Jel:JEL,nonrep
	Classification-MSC-1991:MSC1991,nonrep
	Classification-MSC-2000,nonrep

        Keywords:keywords
        Keywords-Attent:keywords

	HasChapter:documenthandle
	Price, nonrep
        File:cluster:file
	Order-URL:URL

        Number
	Creation-date:date, nonrep
	Publication-date:date, nonrep
	
        Article-Handle:documenthandle
        Book-Handle:documenthandle
        Chapter-Handle:documenthandle
        Paper-Handle:documenthandle
        Software-Handle:documenthandle

        # deprecated: 
	Publisher:cluster:Organization, deprec
}

postproc = ReDIF-Book 1.0 {  
    if ( not ( $object->{author} ) 
	 and not ( $object ->{editor} ) ) {
	error "At least one of author or editor must be defined";
    ;}
    ### move all publisher-* to provider- cluster
    my $provider = $object -> {provider} || [];
    if ( $object->{publisher} ) {
      my @publisher = ( @{ $object->{publisher} } );
      foreach ( @publisher ) {
        push @$provider, $_;
      }
      delete $object->{publisher};

      if ( scalar @$provider ) {
        $object->{provider} = $provider;
      } else {
        error "Provider organization cluster is required";
      }
    }
}


template=ReDIF-Chapter 1.0 {
        Template-Type, key
        Handle:documenthandle, req, nonrep
        Title, req, nonrep
        Author:cluster:Person, req
        Language:LangCode639_1
        Contact-Email:email
        Abstract

        Classification-ACM-1964,nonrep
	Classification-ACM-1991,nonrep
	Classification-ACM-1998,nonrep
	Classification-Ila,nonrep
        Classification-Jel:JEL,nonrep
	Classification-MSC-1991:MSC1991,nonrep
	Classification-MSC-2000,nonrep

        Keywords:keywords, nonrep
        Keywords-Attent:keywords, nonrep

	Provider:cluster:Organization

	Book-Title, nonrep
	Editor:cluster:Person
        Year, nonrep
        Month, nonrep
	Pages, nonrep
	Chapter, nonrep
        Volume, nonrep
        Edition, nonrep
        Series, nonrep
	ISBN, nonrep
        Publication-Status:pubstat, nonrep
        Note
	In-Book:documenthandle, nonrep

        File:cluster:file
	Order-URL:URL

        Article-Handle:documenthandle
        Book-Handle:documenthandle
        Chapter-Handle:documenthandle
        Paper-Handle:documenthandle
        Software-Handle:documenthandle

        # deprecated:
	Publisher:cluster:Organization, deprec
	Sponsor:cluster:Organization, deprec
}

postproc = ReDIF-Chapter 1.0 {  
    ### move all publisher-* to provider- cluster
    my $provider = $object -> {provider} || [];
    foreach ( qw( publisher sponsor ) ) {
      if ( ref $object->{$_} eq 'ARRAY' ) {
        foreach ( @{$object->{$_}} ) {
          push @$provider, $_;
        }
      }
      delete $object->{$_};
    }
    if ( scalar @$provider ) {
      $object->{provider} = $provider;
    }
}



##
## Tangibles template-types
##



template=ReDIF-Person 1.0 {
        Template-Type, key
        Handle:personhandle, req, nonrep
        Name-Full:NAME, req
        Name-First
        Name-Last
	Name-Prefix
        Name-Middle
	Name-Suffix
        Name-ASCII

        Email:email
        Homepage:URL
        Fax
        Postal:postal
        Phone
        WorkPlace:cluster:Organization
	WorkPlace-Organization:institutionhandle

	Author-Paper:documenthandle
	Author-Article:documenthandle
	Author-Software:documenthandle

	Editor-Series:serieshandle

	Author-Book:documenthandle
	Editor-Book:documenthandle
	Author-Chapter:documenthandle

        Classification-ACM-1964,nonrep
	Classification-ACM-1991,nonrep
	Classification-ACM-1998,nonrep
	Classification-Ila,nonrep
        Classification-Jel:JEL,nonrep
	Classification-MSC-1991:MSC1991,nonrep
	Classification-MSC-2000,nonrep

	Short-ID, nonrep
	last-login-date, nonrep
	registered-date, nonrep
}


postproc = ReDIF-Person 1.0 {  
    if ( ref ( $object->{'workplace-institution'} ) eq 'ARRAY' ) {
	$object->{'workplace-organization'} = $object->{'workplace-institution'};
    }
}


template=ReDIF-Institution 1.0 {
        Template-Type, key
        Handle:institutionhandle, required, nonrepeatable

        Primary:cluster:organization
        Secondary:cluster:organization
        Tertiary:cluster:organization
        Quaternary:cluster:organization

	Primary-Defunct
	Secondary-Defunct
	Tertiary-Defunct
        Quaternary-Defunct
}

postproc=ReDIF-Institution 1.0 {
    my ( $title, $title_en );

    my @tit;  my @titEn;
    foreach ( qw( primary secondary tertiary quaternary ) ) {
       if ( $object ->{$_} ) {
	  my $branch = $object ->{$_}[0];
          my $name   = $branch ->{name}[0];
          my $nameEn;
	  if (  exists $branch ->{'name-english'} ) {
             $nameEn = $branch ->{'name-english'}[0];
	  } else { $nameEn = $name; }
	  push @tit,   $name;
	  push @titEn, $nameEn;
       };
    };
    $title    = join "\n\n", @tit;
    $title_en = join "\n\n", @titEn;
    
    $object -> {name}      = $title;

    if ( $title ne $title_en ) {
      $object -> {'name-en'} = $title_en;
    };
}
