package ReDIF::Unicode;

##  Copyright (c) 1997-2001 Ivan Kurmanov. All rights reserved.
##
##  This code is free software; you can redistribute it and/or modify it
##  under the same terms as Perl itself.

$VERSION = "0.1";


use Exporter;
@ISA = ( 'Exporter' ) ;
@EXPORT_OK = qw( &has_utf8_bom has_utf16_bom &has_non_latin1_unicode 
                 &latin1_from_utf8   &utf8_from_latin1 );

$BOM_UTF8 = '\xef\xbb\xbf' ;
use Encode;


sub has_utf8_bom($) {
    my $string = shift;
    return $string =~ /^\xef\xbb\xbf/o ;
}

sub has_utf16_bom($) {
    my $string = shift;
    for ($string) {
      m/\x{FE}\x{FF}/ && return 'BE';
      m/\x{FF}\x{FE}/ && return 'LE';
    } 
    return undef;
}



sub has_non_latin1_unicode {
    my $string = shift;
    Encode::_utf8_on( $string );
    ### the following doesn't work in 5.8.0RC3.  Therefore I tried to
    ### return 1;  Doesn't solve the problem.
#    my $r = $string =~ m/[^\x{0000}-\x{00FF}]/ ;
#    warn "has_non_latin1_unicode: '$string' res: $r\n";
    return  $string =~ m/[^\x{0000}-\x{00FF}]/ ;
}

#use Unicode::String qw( &utf8  &latin1 );

use Carp;

sub utf8_from_latin1($) {
  my $data = shift;
  Encode::_utf8_off( $data );
  return Encode::decode( "iso-8859-1", $data );
}

sub latin1_from_utf8($) {
  my $data = shift;
  Encode::_utf8_on( $data );
  return Encode::encode( "iso-8859-1", $data );
}

1;
