#!/usr/local/bin/perl

use strict;

use Getopt::Std;

use vars qw( %options );

getopts( "sFho:f", \%options );


my $too_old;
my $its_a_file;

use Events;

# BEGIN{
#  Events->register_event_handler( "*", \&print_event );
# }


if ( $options{'h'} ) { # help
  print <<ENDEND;
This is RePEc-Index database update program.

Usage: $0 [options] COLLECTION_NAME [COLLECTION_PATH]

Will update database for collection COLLECTION_NAME.  If the
COLLECTION_PATH is given, will only update the given part of the
collection.  The path must be relative to the collection root
directory. (The path may also be a filename.)

Options: 

  -s   be silent

  -o SECONDS 
       read all the files, which were not processed for that
       many seconds, even if they were not modified recently.

  -F   full update - process every data file of the collection
ENDEND
 exit;
}
if ( not $options{'s'} ) {   # silent
  Events->register_event_handler( "*", \&print_event );
}

if ( $options{'o'} ) { # too old is ...
  $too_old = $options{'o'};
}

if ( $options{'F'} ) { # Full update, equal to "-o 1" ("too old is 1")
  $too_old = 1; 
}


require RePEc::Index::Update;


my $authority = shift
  || die "Give me a name of the authority, whose collection to update.  Give '-h' to see usage help.";

print "Going to update collection '$authority'\n";

my $dir = shift ;

if ( not $dir ) {
  warn "No directory to update specified, defaulting to the collection's root directory";
  $dir = "/";
}

my @par = ();
if ( defined $too_old ) { push @par, "TOO_OLD_IS", $too_old; }

RePEc::Index::Log::set_printout_level ( 0 );

my $update = RePEc::Index::Update -> new( $authority, @par );

$update -> process_this( $dir );


sub print_event {
  my $event = shift;
#  my @params = @_;
  my @params;

  foreach my $p ( @_ ) {
    if ( ref $p ) { next; }
    push @params, $p;
  }

  $event =~ s/RePEc::Index::Update/U/g;
  $event =~ s/RePEc::Index:://g;
  $event =~ s/::/ /;
  
  if ( $event eq 'U RECORD' ) { return; }
#  if( $event =~ m/U RECORD / ) { return; }

  print "$event: ", join( '|', @params ), "\n";
}

print "finished update\n";
