use AMF::Tests;
use strict;

eval " use AMF::Parser; ";
test not $@;

my $res = amf_open_file( 't/acis-citations.amf.xml' );
test $res;

my $text = amf_get_next_noun();
test $text;

use Data::Dumper;

#print Dumper( $text );

# source document id

my $id = $text -> get_value( 'REF' );
test $id;
print "src doc id: $id\n";


my @cits;
# identified citations

my $identfd = $text -> {references};

my $string;
my $target;
foreach ( @$identfd ) {

  if ( $string and $target ) {
    print "citation: '$string' points to: '$target'\n\n";
    push @cits, { ostring => $string, trgdocid => $target };
    undef $string;
    undef $target;
  }

  if ( UNIVERSAL::isa( $_->[0], 'AMF::Noun' )) {
    $target = $_->[0]->ref;
  } elsif ( $_->[0] eq 'http://acis.openlib.org/ referencestring' ) {
    $string = $_->[2][0];
  }
}

if ( $string and $target ) {
  print "citation: '$string' points to: '$target'\n\n";
  push @cits, { ostring => $string, trgdocid => $target };
}

test scalar @cits == 2;
test $cits[0]->{ostring} eq ' text of citation 1 ';
test $cits[0]->{trgdocid} eq 'c:text2';


# unidentified citations
my @unidentfd = $text->get_value( 'reference/literal' );

foreach ( @unidentfd ) {
  my $string = $_;
  print "Unidentified citation: '$string'\n\n";
  push @cits, { ostring => $string };
}

test scalar @cits == 3;
test $cits[2]->{ostring} eq ' unidentified citation 1 ';


#test $text->md5_checksum;
test not amf_get_next_noun();
