package ACIS::MiLa::Core;

use strict;

use Carp::Assert;


sub define_func {
  my $name = shift;
  my $func = shift;

  assert( not ref $name and $name ne '' );
  assert( not ref( $func ) );

  $ACIS::MiLa::names -> {$name} {func} {func} = $func;
  ### XXX signature pattern?
  return ();
}

sub use_ {
  my $name = shift;
 
  eval "use $name;";
  
  if ( $@ ) {
    warn "loading $name failed: '$@'";
    return { err => $@ };
  } else {
    return ();
  }
}


use ACIS::MiLa;

sub load {
  ACIS::MiLa::load_file( @_ );
}


1;
