package ACIS::MiLa;

use strict;

use ACIS::MiLa::Core;
use ACIS::MiLa::DataBuilder;
use ACIS::MiLa::Reader;
use ACIS::MiLa::Eval;

use Exporter;

use vars qw( $names $stack 
             $res 
             $analizator
             @ISA @EXPORT
           );

@EXPORT = qw( execute run );
@ISA = qw( Exporter );

$names = {};
$res   = [];
# $stack = [];



$names -> {func} {func} = {
   func => 'ACIS::MiLa::Core::define_func',
   ### XXX signature pattern?
};

$names -> {use} {func} = {
   func => 'ACIS::MiLa::Core::use_',
};

$names -> {load} {macro} = {
   func => 'ACIS::MiLa::Core::load',
};

$names -> {'dump-data'} {func} = {
   func => 'ACIS::MiLa::dump_data',
};





my $position;

use Carp::Assert;


sub execute {
  my $file = shift;
  $analizator = ACIS::MiLa::DataBuilder -> new( $res );
  _load_file( $file );
  return run();
}

sub run() {
  my $r = ACIS::MiLa::Eval::transform ( $res, $names );
  return $r;
}


use Carp;

sub dump_data {

#  confess;
  require Data::Dumper;
  eval 'use Data::Dumper';

#  print "Stack: ----\n",
#    Dumper( $stack ),
#      "\n-----------\n";
  
  print "- Data: ---\n",
    Dumper( $res ),
      "\n-----------\n";
  return();
}



sub load_file {
  my $file = shift;
  $analizator = ACIS::MiLa::DataBuilder -> new;
  return _load_file( $file );  
}


sub _load_file {
  my $file  = shift;
  
  my $r;
  if ( open_src_file( $file ) ) {
    
    my $toktype;
    my $token;

    while ( ( $toktype, $token ) = get_next_token() ) {
      
      my $l_no = lineno;
      my $f = "token_$toktype";
      $analizator -> $f ( $token, "line $l_no, file: $file" );

      if ( $toktype eq 'eof' ) { 
        last;
      }
      
    }
    $r = $analizator -> result;
    close_src();
    
  }

#  return( @$r );
  return ();
}




1;
