#!/usr/local/bin/perl

#
#  Copyright (c) 2000-2002 Ivan Kurmanov, RePEc project.  All rights
#  reserved.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the same terms as Perl itself.
#

use strict;

use RePEc::ShortIDs::Client;

use RePEc::local;

my $source_dir = $RePEc::local::hopec_write_out_dir;

my $command = shift;


use Carp::Assert;

sub update {
  my $over = shift;

  use ReDIF::Parser;

  assert( -d $source_dir );

  opendir SDIR, $source_dir;
  my @files = readdir SDIR;
  close SDIR;

  my $fcount = 0;
  my $tcount = 0;

  foreach (@files) {
    my $file = $_;

    if (/\.rdf$/i) {
      $fcount ++;
      ReDIF::Parser::open_file( "$source_dir/$file" );
      my $template = ReDIF::Parser::get_next_template();
      if ( $template ) {
	RePEc::ShortIDs::process_record( $template, $over );
	$tcount ++;
      }
    }
  }
  print "$fcount files processed\n";
  print "$tcount templates processed\n";

}

if ( $command eq 'update' ) {

  update( );

} elsif ( $command eq 'update-with-overwrite' ) {

  update( 1 );

} elsif ( $command eq 'import' ) {
  my $log_fname = shift;

  die if not -e $log_fname or not -r _;

  my $items = RePEc::ShortIDs::read_logfile( $log_fname );
  print "That many id/handle pairs read from the log: $items\n";

} elsif ( $command eq 'import-with-clear' ) {

  my $log_fname = shift;

  die if not -e $log_fname or not -r _;

  my $items = RePEc::ShortIDs::read_logfile( $log_fname, 1 );
  print "That many id/handle pairs read from the log: $items\n";


} else {

print q!This is short-ids script to maintain Short-ID database for RePEc 
templates/handles.

Invoke in one of the following ways: 

 $ short-ids.pl update

     Will read the templates in the $source_dir and will assign ids
     to the new handles, writing log file in the RePEc::ShortIDs' home
     directory.

     Will write the files with Short-ID attribute added to the
     RePEc::ShortIDs' output directory, whenever these files are not
     yet present.

 $ short-ids.pl update-with-overwrite

     Same as "update", but will write template files with Short-ID in
     output directory.

 $ short-ids.pl import <log-file-name>

     Will import id/handle data from the given log file, adding the
     data to the database.

 $ short-ids.pl import-with-clear <log-file-name>

     Will clear the database, and then import the data from the log
     file.
!;

}



1;
