package RePEc::Index::Storage;

use strict;
use Carp::Assert;

## schmorp
#use Lib32::Decode;
use Common::Data;
## /schmorp

sub prepare_db_env {
  my $dir = shift;

  if( not $Env ) {
    $Env = new BerkeleyDB::Env 
      (
       -Home     => $dir,
       -Flags    => DB_CREATE | DB_INIT_MPOOL,
       # | DB_INIT_LOCK | DB_INIT_LOG | DB_INIT_MPOOL | DB_INIT_TXN
#       -Mode     => 0664,
       -Verbose  => 1,
#       -Config   => { DB_TMP_DIR => '/tmp' },
      );
    if( not $Env ) {
      die "Can't get my hands on the DB in $dir: $BerkeleyDB::Error ($!)";
    } else { 
    }
  }
  assert( $Env );
}


sub start_transaction {
  if ( not $Env ) {
    warn "Starting a transaction, while there's no environment still!";
    return undef;

  } else {
    return 1;
  }
}


sub commit_transaction {
  return;
}


sub load_record_from_db_txn {
  my ( $txn, $file_name, $key ) = @_;
  
  my $hash = open_dbfile( $file_name, 'read' ) 
    or return undef;

  assert( $hash );
  my $db = tied %$hash;

  my $val;
  $db -> db_get( $key, $val );

  if ( defined $val ) {
    my $record;
    ## schmorp 
    #$record = eval { thaw( $val ); };
    #if ( $@ ) { 
    #  # warn "Storage: $@"; 
    #  warn "decoding via daemon";
    #  $record=Lib32::Decode::via_daemon($val);
    #  if (not $record ) { 
    #    warn "decode via daemon failed";
    #    return undef;          
    #  }
    #}
    #return $record;
    $record=&Common::Data::inflate_json($val);
    ## /schmorp
  } 
  else {
    return undef;
  }
}


sub load_record_from_db_txn_readonly {
  load_record_from_db_txn( @_ );
}


##############################################################################
#   sub   SAVE RECORD TO DB   ################################################
##############################################################################

sub save_record_to_db_txn {
  my ( $txn, $file_name, $key, $record ) = @_;
    
  my $hash = open_dbfile( $file_name, 'write' ) 
    or return undef;

  assert( $hash );
  my $db = tied %$hash;

  ## schmorp
  # my $value = nfreeze( $record );
  my $value=&Common::Data::deflate($record);
  ## /schmorp

  if ( defined $value ) {
    $db->db_put( $key, $value );
  } else {
    return undef; 
  }
}


sub delete_record_from_db_txn {
  my ( $txn, $file_name, $key ) = @_;
  
  my $hash = open_dbfile( $file_name, 'write' ) 
    or return undef;

  assert( $hash );
  my $db = tied %$hash;

  $db -> db_del( $key );
}



###############



my %OPEN_FILES; 
my @FILES;  ### $#FILES = 100;
my $Open_Op = 1;

my %permissions = ( read  => DB_RDONLY,
                    write => DB_CREATE );


sub open_dbfile {
    my ( $filename, $permission ) = @_;

    my $hash_ref;
    
    my $data = $OPEN_FILES{$filename} ;

    if ( defined $data ) {

        my $re_open = 1;
        my $file_info = $data;
        my $p = $file_info->{perm};

        if ( ( ( $permission eq 'read' ) and ( $p eq 'write' ) ) 
               or ( $permission eq $p ) ) {
            $re_open = 0;
        }

        if ( not $re_open ) {
          assert( ref( $file_info->{hash} ) eq 'HASH' );
          $hash_ref = $file_info->{hash};

        } else {

            untie %{ $file_info->{hash} };
            my $perm = $permissions{ $permission };
            my %data;

            my $db = tie( %data, 'BerkeleyDB::Hash', 
                 -Env => $Env,
                 -Filename => $filename, 
                 -Flags    => $perm )
              or error("Cannot open file $filename: $! $BerkeleyDB::Error\n"); 

#           warning "re-opened $filename ($permission) $file_info->{hash}";

            $file_info->{db}   = $db;
            $file_info->{hash} = \%data;
            $file_info->{perm} = $permission;
            $hash_ref = \%data;
        }
        $file_info -> {last_used} = $Open_Op;
        
    }  else {

        ### open a new item
        my $file_info = {
                         last_used => $Open_Op,
                         filename  => $filename, 
                         perm      => $permission,
                         };
        my %data;
        my $perm = $permissions{ $permission };
        my $ok = 
            tie( %data, 'BerkeleyDB::Hash', 
                 -Env => $Env,
                 -Filename => $filename, 
                 -Flags    => $perm );

#       warning "open $filename, perm: $perm ($permission) ";

        if( $ok ) {
            $file_info -> {db}   = $ok; 
            $hash_ref = $file_info -> {hash} = \%data; 
            unshift @FILES, $file_info;
            $OPEN_FILES{$filename} = $file_info;
            $Open_Op ++;

        } else {
          error("Cannot open file $filename: $! $BerkeleyDB::Error\n"); 
        }
    }

    if ( not $Txn and not ( $Open_Op % 5 ) ) {   ### if $Open_Op = 3n, n is integer

        ###  remove (untie) old open file items

        ###  'old' is used 8 times ago;  what 'time' is defined elsewhere
        my $old_mark = $Open_Op - 8;
        
        my $c = 0;
        my $f;
        while ( 1 ) {    ### now check every open data file
            $f = $FILES[$c];

            if ( $f->{last_used} < $old_mark ) {
                untie %{$f->{hash}};   ### ?
                delete $OPEN_FILES{$f->{filename}};
                splice ( @FILES, $c, 1 ) ;

            } else {
                $c ++;
            }

            last if ( $c > $#FILES );  ### break out if reached the array end
        }

    }

    if ( defined $hash_ref ) {
      assert( ref $hash_ref );
      assert( ref( $hash_ref ) eq 'HASH' );
    }

    return $hash_ref;
}



END {
  undef $Txn;
  foreach my $f ( @FILES ) {
    $f->{db}->db_close();
    undef $f->{db};
    undef $f;
  }
  undef $Env;
}



1;
