package RePEc::Index::Storage;

use strict;

use Carp::Assert;

use vars qw( @EXPORT_OK @ISA );

## schmorp
# use Lib32::Decode;
use Common::Data;
## /schmorp


use Exporter;

@ISA = qw( Exporter );
@EXPORT_OK = qw( 
                &load_record_from_db 
                &save_record_to_db
                &open_dbfile
                &get_dbfile_hash_ref 
                &delete_record_from_db

                &load_record_from_db_txn
                &load_record_from_db_txn_readonly
                &save_record_to_db_txn
                &delete_record_from_db_txn
                &start_transaction
                &commit_transaction

               );

## schmorp
#use Storable qw( thaw nfreeze store retrieve );
use Common::Data;
## /schmorp

my $Log;

sub set_log {
  $Log = shift;
}

# use RePEc::Index::Log;

sub log_it {
    $Log -> log_it( @_ );
}

sub error   { 
  if( defined $Log ) {
    $Log -> error( @_ );
  } else {
    warn "R::I::Storage error: ", @_, "\n";
  }
}

sub warning { 
  if( defined $Log ) {
    $Log -> warning( @_ ); 
  } else {
    warn "R::I::Storage warning: ", @_, "\n";
  }
}



    

##############################################################################
#   sub   LOAD RECORD FROM DB   ##############################################
##############################################################################

sub load_record_from_db {
  my ( $key, $file_name ) = @_;
  
  my $Data = open_dbfile( $file_name, 'read' ) 
    or return undef;

  assert( $Data );
  assert( ref $Data );
  assert( ref ( $Data ) eq 'HASH' );

  if ( defined $Data->{$key} ) {
    my $serial = $Data->{$key} ;
    my $record;

    ## schmorp
    #$record = eval { thaw( $serial ); };
    #
    #if ( $@ ) { 
    #  # warn "Storage: $@"; 
    #  warn "decoding via daemon";
    #  $record=Lib32::Decode::via_daemon($serial);
    #  if (not $record ) { 
    #    warn "decode via daemon failed";
    #    return undef;          
    #  }
    #}
    $record=&Common::Data::inflate_json($serial);
    ## /schmorp

    return $record;
  } 
  else {
    return undef;
  }
}


##############################################################################
#   sub   SAVE RECORD TO DB   ################################################
##############################################################################

sub save_record_to_db {
  my ( $record, $file_name, $key ) = @_;
    
  my $Data = open_dbfile( $file_name, 'write' ) 
    or return undef;

  ## schmorp
  # my $value = nfreeze( $record );
  my $value=&Common::Data::deflate($record);
  ## /schmorp 

  if ( defined $value ) {
    return $Data -> {$key} = $value ;
  } else {
    return undef; 
  }
}


###############################################################################

sub get_dbfile_hash_ref {
    my $file_name = $_[0];
    my $Data = open_dbfile( $file_name, 'read' );
    return $Data;
}

###############################################################################

sub delete_record_from_db {
  my ( $key, $file_name ) = @_;
  
  my $Data = open_dbfile( $file_name, 'write' ) 
    or return undef;

  delete $Data->{$key};
}


###############################################################################


# some more inits

use BerkeleyDB;

use vars qw( $Env $Txn );


#use RePEc::Index::Storage::BDB;
use RePEc::Index::Storage::BDBwithTxn;


1;
