package RePEc::Index::Reader;

use strict;
use warnings;

use Carp::Assert;

use RePEc::Index;
use RePEc::Index::Config;

use RePEc::Index::Storage qw(
                             &load_record_from_db_txn_readonly
                            );

use RePEc::Index::Collections;

# RePEc::Index::Storage::prepare_db_env( $RePEc::Index::Config::DATADIR );

sub __get {
  my $col  = shift || die;
  my $what = shift || die;
  my $id   = shift || die;

  my $collection = $RePEc::Index::COLLECTIONS->{$col};

  if ( not $collection ) {
    die "Invalid (unknown) collection: '$col'";
  }

  my $datadir = $RePEc::Index::Config::DATADIR
    . "/" . $collection->{prefix};
  
  my $db = "$datadir/$what";

#  print "db: $db ($id)\n";
  return load_record_from_db_txn_readonly( 0, $db, $id );
}

sub new {
  my $class = shift;
  my $col   = shift;
  
  my $self  = { @_ };

  $self->{collection_name} = $col;

  assert( $col );

  my $collection = $self->{collection} = 
    $RePEc::Index::COLLECTIONS->{$col};

  if ( not $collection ) {
    die "Invalid (unknown) collection: '$col'";
  }

  $self->{collection} = $collection;

  $self->{has_records_db} = $collection->{options}{records_db};
  
  my $global_datadir = $RePEc::Index::Config::DATADIR;

  my $datadir = $self->{datadir} 
    = $global_datadir . "/" . $collection->{prefix};

  if ( not -d $datadir and not -e _ ) {
    warn "Collection's data dir $datadir doesn't exist";
  }

  RePEc::Index::Storage::prepare_db_env( $RePEc::Index::Config::DATADIR );
  
  $self->{files_db}   = "$datadir/files";
  $self->{records_db} = "$datadir/records";
  $self->{history_db} = "$datadir/history";
  $self->{conflict_db}= "$datadir/conflicts";

  bless $self, $class;
}

sub DESTROY {
  my $self = shift;
  RePEc::Index::Storage::release_res();
}

sub get_file {
  my $self = shift;
  my $file = shift;
  my $db = $self->{files_db};
  return load_record_from_db_txn_readonly( 0, $db, $file );
}

sub get_history {
  my $self = shift;
  my $id   = shift;
  my $db = $self->{history_db};
  return load_record_from_db_txn_readonly( 0, $db, $id );
}


sub get_record {
  my $self = shift;
  my $id   = shift;
  my $db = $self->{records_db};
  return load_record_from_db_txn_readonly( 0, $db, $id );
}

sub get_conflict {
  my $self = shift;
  my $id = shift;
  my $db = $self->{conflict_db};
  return load_record_from_db_txn_readonly( 0, $db, $id );
}


sub get_all_about_record {
  my $self = shift;
  my $id   = shift;
  my $hisdb = $self->{history_db};
  my $recdb = $self->{records_db};
  my $condb = $self->{conflict_db};

  my $history  = load_record_from_db_txn_readonly( 0, $hisdb, $id );
  my $record   = load_record_from_db_txn_readonly( 0, $recdb, $id );
  my $conflict = load_record_from_db_txn_readonly( 0, $condb, $id );
  return [$history, $record, $conflict];
}


1;

__END__
