package RePEc::Index::Log;

use strict;

use Carp::Assert;

use POSIX qw( &strftime );

# use RePEc::Index::Config;

my $log_filename = $RePEc::Index::Config::LOG;

my $log_level    = $RePEc::Index::Config::SETTINGS->{log_level} || 3;
#$log_level    = 0;
my $log_print_level  = 9;
#$log_print_level  = 0;

sub set_printout_level { $log_print_level = shift; }

# log level is a number from 0 to 9.  Log messages of a level may be
# accompanied with a character to express it's importance

my $log_signs = "    .-+*#!";

sub log {
  my $level = shift;

  undef $!;
  if ( $level < $log_level
       and $level < $log_print_level ) {
    # nothing really to do
    return ();
  }

  my $sign = substr( $log_signs, $level, 1 );
  my @msg = @_;

  if ( $level >= $log_level ) {
    assert ( $log_filename );

    if ( open LOG, ">>", $log_filename ) {
      
      print LOG
        strftime( "%a %b %e %H:%M:%S %Y", localtime ),
          " $sign ", @msg, "\n";

      close LOG;

    } else {
      warn "Sys: $!"; undef $!; 
    }


  }

  if ( $level >= $log_print_level ) {
    print
      strftime( "%H:%M:%S", localtime ),
        " $sign @msg\n";
  }

}


### object oriented interface

sub error {
  my $class = shift;
  my @msg = @_;
  &log ( 8, @msg );
}

sub warning {
  my $class = shift;
  my @msg = @_;
  &log ( 6, @msg );
}

sub log_it {
  my $class = shift;
  my @msg = @_;
  &log( @msg );
}


1;
