# this is Makefile.PL for the RePEc-Index package

##  Copyright (c) 1999,2002 Ivan Kurmanov.
##  Portions copyright (c) 1996, 1997 Graham Barr.
##  All rights reserved.
##  This code is free software; you can redistribute it and/or modify it
##  under the same terms as Perl itself.

##  portions taken from Configure of Libnet-1.0606 package.

##  writes a tiny perl module file with a RePEc-index's home directory name


# AGENDA:

# check for a parameter - no

# ask the user for the home directory

# arrange it accordingly

# store the configuration into lib/RePEc/Index/local_setup.pm

# write the makefile

use ExtUtils::MakeMaker ;



###############################################
sub Prompt {
    my($prompt,$def) = @_;
    $def = "" unless defined $def;
    chomp($prompt);

    ExtUtils::MakeMaker::prompt( $prompt, $def );
}

sub get_bool ($$) {
    my($prompt,$def) = @_;

    chomp($prompt);
    my $val = Prompt($prompt,$def ? "yes" : "no");
    $val =~ /^y/i ? 1 : 0;
}

###############################################

sub configure {

  print "Preparing to install RePEc-Index perl package.\n";
  print <<MSG;

RePEc-Index needs a directory to store its data files and to write its
logs.  It must be writable by the user who will use the package.  You
give me a name, I check the directory and if necessary I create
appropriate structure below it.

The package will remember the name of the directory you give, and it
will always (by default) use it.  If you ever need to move the
directory to another place, feel free to do that.  You'll only have to
reinstall the RePEc-Index again to let it remember you new directory as
its home.

MSG

  my $EXISTING_SETTING;
  my $NEW_SETTING;

  $CONF_FILENAME     = "RePEc/Index/local_setup.pm"     ;
  $OUT_CONF_FILENAME = "lib/RePEc/Index/local_setup.pm" ;

  no strict 'vars';
  
  $MAIN_CONFIG_VARIABLE_NAME = "RePEc::Index::local_setup::HOMEDIR";


  my $new;
  my $t1 = eval {
    do ( $CONF_FILENAME );
  };
  
  my $full_conf_filepathname = $INC{$CONF_FILENAME};
  
  if( defined ${ $MAIN_CONFIG_VARIABLE_NAME } ) {
    $EXISTING_SETTING = ${ $MAIN_CONFIG_VARIABLE_NAME };
  }
  
  if( $@ ) {
    # no current configuration
    print "A problem while loading $CONF_FILENAME: $@\n";
  } else {
  }
  
  if( $EXISTING_SETTING ) {
    print "Your system is currently configured to use the following \ndirectory as RePEc-Index home:\n\n",
      "\t$EXISTING_SETTING\n\n(taken from $full_conf_filepathname)\n\n";
    
    my $t = get_bool ( "Do you wish to change that?", 0 );
    
    if( not $t ) {
      $NEW_SETTING = $EXISTING_SETTING;
      check_and_prepare_dir ( $EXISTING_SETTING );
      write_config( $EXISTING_SETTING );
      
    } else {
      $NEW_SETTING = '';
    }
  }
  
  if ( not $NEW_SETTING ) {
    
    my $dir = prompt (
                      "What directory to use as the RePEc-Index home?\nPlease give a full absolute path:" );
    
    if ( check_and_prepare_dir ( $dir ) ) {
      write_config ( $dir );
    }
  }
  
}

sub check_and_prepare_dir{
  my $dir = shift;
    
  if (not $dir) {
#    die "You must give a directory name to install RePEc-Index";
    return undef;
  }

  if ( $dir !~ /^(\/|\w\:\\)/ ) {
    die "You must give an absolute pathname as RePEc-Index' home dir";
  }

  if ( not -e $dir ) {
    print "Specified directory doesn't exists. ";
    if ( get_bool( "Create it?", 1 ) ) {
      mkdir $dir;
    } else {
      die "You must give a directory name to install RePEc-Index";
    }
  } else {
    if ( not -d $dir
       or not -w _ ) {
      die "The directory is invalid: $dir";
      return 0;
    }
  }

  if ( not -e "$dir/data" ) {
    mkdir "$dir/data";
  }
  if ( not -e "$dir/backup" ) {
    mkdir "$dir/backup";
  }

  if ( not -e "$dir/collections" ) {
    print 
"\nRemember you should create \"collections\" file in this directory\nto reflect local configuration.\n";

  }
  return 1;

}

sub write_config {
    my $dir = shift 
      or die;

    open( OUT, ">$OUT_CONF_FILENAME" )
        or die "Cannot open $OUT_CONF_FILENAME for writing"; 

    print OUT <<SETUP_CONF_START;

# Please do not modify this unless you know what you are doing.
# created by Makefile.PL of RePEc-Index package.

package RePEc::Index::local_setup;

\$HOMEDIR = "$dir";

1;

SETUP_CONF_START
    ;

    close OUT;

    print "\nSaved $OUT_CONF_FILENAME. Current configuration:\n\n";

    undef $$MAIN_CONFIG_VARIABLE_NAME; 


    my $t2 = eval q!
      use lib "./lib";
      do ( $OUT_CONF_FILENAME );
    !;

    die "The created file is bad..." if $@;

    display_config();

    print "\n";
}




############################


sub display_config {

    print "\tRePEc-Index home directory: ";

    if (defined $$MAIN_CONFIG_VARIABLE_NAME  ) {
        print $$MAIN_CONFIG_VARIABLE_NAME;
    } else {
        print "not set";
    }
    print "\n";
    return 1;
}


if(not $ENV{MAKEMAKEFILE}) { configure(); }
WriteMakefile(
              NAME    => 'RePEc-Index',
              VERSION => '0.38.3',       # VERSION
              'EXE_FILES' => [ 'reindex.pl' ],
              'PREREQ_PM' => {
                              "ReDIF::Parser" => "1.38",
                              "Carp::Assert" => "",
                              "Storable" => "1",
                              "BerkeleyDB" => "",
#                              "Events" => "",
              },

              'dist'      => {
                  TARFLAGS => '-cvf',
                  COMPRESS => 'gzip -9f', 
                  SUFFIX   => '.gz',
              },
);

