# Update JELcodes.pm

use XML::Simple;
use LWP::UserAgent;
use HTTP::Request;

use ReDIF::JELcodes; # Current version

use strict;

my( %newjel );

my $jelspec = 'http://www.aeaweb.org/econlit/classificationTree.xml';

my $ua = LWP::UserAgent->new( );
my $req = HTTP::Request->new( 'GET', $jelspec );

my $r = $ua->request( $req );
if ( $r->is_error() ) {

  print $->status_line();
  exit;
  
}

my $jelservertime = $r->header( 'Last-Modified' );

my $xmlstring = $r->content();

my $xml = eval { XMLin( $xmlstring, 
                     ); 
              };

foreach my $k ( keys %$xml ) {
  
  if ( $k eq 'classification' ) {
    %newjel = get_codes( $xml->{$k} );
  }
  
}

print "\n\n";

foreach my $c ( keys %newjel ) {
  $newjel{$c} =~ s/\s*&bull;/;/g;
  $newjel{$c} =~ s/&ndash;/-/g;
  $newjel{$c} =~ s/\s+$//g;
  $newjel{$c} =~ s/^\s+//g;
}

print "New codes\n";
foreach my $c ( sort keys %newjel ) {
  print "$c: '$newjel{$c}'\n" unless defined $ReDIF::JELcodes::JEL{$c};
}

print "\n\nChanged codes\n";
foreach my $c ( sort keys %newjel ) {
  print "$c: '$newjel{$c}' '$ReDIF::JELcodes::JEL{$c}'\n" if ( defined $ReDIF::JELcodes::JEL{$c} and $newjel{$c} ne $ReDIF::JELcodes::JEL{$c} );
}

print "\n\nCodes that are no more\n";
foreach my $c ( sort keys %ReDIF::JELcodes::JEL ) {
  print "$c: '$ReDIF::JELcodes::JEL{$c}'\n" unless defined $newjel{$c};
}

# Update JEL codes and keep old ones
foreach my $c ( sort keys %newjel ) {
  $ReDIF::JELcodes::JEL{$c} = $newjel{$c};
}

# write new module file

my @time = localtime();
my $date = sprintf( "%4d-%02d-%02d", $time[5]+1900, $time[4]+1, $time[3] );

my $outfile = "JELcodes$date.pm";

print "\n Creating $outfile\n";

open( OUT, ">$outfile" ) or die "Could not open $outfile";
print OUT<<_A_;

package ReDIF::JELcodes;

#
# JELcodes.pm created on $date by updateJEL.pl from
# $jelspec 
# Server reported file time
# Last-Modified: $jelservertime
#

%JEL = (
_A_

my $t;
foreach my $c ( sort keys %ReDIF::JELcodes::JEL ) {
  ( $t = $ReDIF::JELcodes::JEL{$c} ) =~ s/'/\\'/g;
  print OUT " '$c' => '$t',\n";
}

print OUT ");\n\n";

close( OUT );

sub get_codes {
  
my( $xml, %codes ) = @_;

if ( ref $xml eq 'ARRAY' ) {
  
  foreach my $i ( @$xml ) {
    if ( ref $i eq 'HASH' ) {
      if ( $i->{code} and $i->{description} ) {
        $codes{$i->{code}} = $i->{description};
      }
      if ( $i->{classification} ) {
        %codes = get_codes( $i->{classification}, %codes );
      }
    }
  }
  
} elsif ( ref $xml eq 'HASH' ) {

  if ( $xml->{code} and $xml->{description} ) {
    $codes{$xml->{code}} = $xml->{description};
  }
  if ( $xml->{classification} ) {
    %codes = get_codes( $xml->{classification}, %codes );
  }
  
}

return( %codes );

}