use ReDIF::Testing;

use strict;
use warnings;

my $test_file = "t/x_test.rdf";

use ReDIF::Parser qw(
     &redif_open_file 
     &redif_get_next_template
);

ReDIF::Parser::set_parser_options(  x_attributes => 1  );


my $t = redif_open_file( $test_file ) ;
test( $t );
  
$t = redif_get_next_template();

test( $t );
test( $t ->{handle}[0] eq 'RePEc:jen:jenavo:9906-01' );

$t = redif_get_next_template();

use Data::Dumper;
print Data::Dumper->Dump( [$t], ['t'] );

test( $t->{'x-abstract'} );
test( $t->{'x-abstract'}[0] );

$t = redif_get_next_template();

test( $t->{author} [0] {'x-character'} );
test( $t->{author} [0] {'x-character'}[0] =~ /kind/ );

test redif_open_file( 't/eeaart22_3.rdf' );
test $t = redif_get_next_template();
print Data::Dumper->Dump( [$t], ['t'] );

test $t ->{'x-file-ref'};
test $t ->{'x-test'};