#  -*- Mode: perl -*-

BEGIN {

    eval { require 5.8.0; };
    if( $@ ) {
      print "1..0 # Skip: perl 5.8.0 or newer required\n";
      exit (0);
    }
    
  }

use Test;


BEGIN { plan test => 15 ; }

{
  my $data ;
  
  open    FILE, "<t/unicode/utf8-bom";
  binmode FILE;
  read    FILE, $data, 100 ;
  close   FILE;
  
  ok  $data =~ /\xef\xbb\xbf/ ;
  ok  $data !~ /\xef\xdb\xbf/ ;
  
}



{
  my $data ;
  
  open    FILE, "<t/unicode/test_utf8_1.rdf";
  binmode FILE;
  read    FILE, $data, 1000 ;
  
  ok  $data =~ /\xef\xbb\xbf/ ;

  ok  $data =~ /\x6a/ ;  # plain char 'j'
  ok  $data !~ /\xf6/ ;  # non-latin1 char 'o' with two points above it
  ok  $data =~ /\xc3\xb6/ ; # utf8-encoded non-plain latin1 char 'o' with two points above it
  ok  $data =~ /\xd0\x91/ ;
  
  seek    FILE, 3, 0;
  binmode FILE, ":utf8";
  read    FILE, $data, 1000 ;
  close   FILE;
  
  ok  $data =~ /\x6a/ ;  # plain char 'j'
  ok  $data =~ /\xf6/ ;  # non-plain non-latin1 char 'o' with two points above it
  ok  $data !~ /\xc3\xb6/ ; # utf8-encoded non-plain latin1 char 'o' with two points above it
  
  ok  $data !~ /\xd0\x91/ ;
  ok  $data =~ /\x{0415}/ ;
  ok  $data !~ /\x{2029}/ ;
  ok  $data =~ /[^\x00-\xFF]/ ;
  ok  $data !~ /^[\x00-\xFF]+$/ ;
}







