### -*- Mode: perl -*-

eval " use ReDIF::Parser; ";

test( not( $@ ), $@ );

use ReDIF::Parser qw( &redif_open_dir
		      &redif_open_dir_recursive
		      &redif_get_next_template );

my $r;
my $t;

$r = redif_open_dir( 't/' );
test ( $r );

if(
   not (
	( $ReDIF::Parser::files_list[0] lt $ReDIF::Parser::files_list[1] ) 
	and ( $ReDIF::Parser::files_list[1] lt $ReDIF::Parser::files_list[2] ) 
	and ( $ReDIF::Parser::files_list[2] lt $ReDIF::Parser::files_list[3] ) 
	and ( $ReDIF::Parser::files_list[3] lt $ReDIF::Parser::files_list[4] ) 
	)
   ) {
    $do_sorting_test = 1;
}

test( scalar @ReDIF::Parser::files_list, join( ', ',  @ReDIF::Parser::files_list ) ); 

while( $t = redif_get_next_template() ) {
    my $filename = $t->{FILENAME};
    print "got a template from $filename\n";
    $files{$filename}++; 
};

test( ( scalar( keys %files ) > 9) , scalar (keys %files ) );


print "now open_dir_recursive()\n";

$r = redif_open_dir_recursive( 't/' );
test ( $r );

test( scalar @ReDIF::Parser::files_list, join( ', ',  @ReDIF::Parser::files_list ) ); 

while( $t = redif_get_next_template() ) {
    my $filename = $t->{FILENAME};
    print "got a template from $filename\n";
    $files{$filename}++; 
};

test( ( scalar( keys %files ) > 15 ) , scalar (keys %files ) );


if( $do_sorting_test )  {

    $r = redif_open_dir( 't/', 1 );

    test( 
	  ( $ReDIF::Parser::files_list[0] lt $ReDIF::Parser::files_list[1] ) 
	  and ( $ReDIF::Parser::files_list[1] lt $ReDIF::Parser::files_list[2] ) 
	  and ( $ReDIF::Parser::files_list[2] lt $ReDIF::Parser::files_list[3] ) 
	  and ( $ReDIF::Parser::files_list[3] lt $ReDIF::Parser::files_list[4] ) 
	  , join( ', ',  @ReDIF::Parser::files_list ) 
	  ); 
    
}

###############################################################
#############     TESTING   FRAMEWORK     #####################
###############################################################

sub test {
    push @TESTS, shift;
    push @MESSAGES, shift;
}

sub ok { 
    push @TESTS, 1; 
    push @MESSAGES, shift;
}
sub nok { 
    push @TESTS, 0; 
    push @MESSAGES, shift;
}



END { 

    my $tests = scalar @TESTS;

    if( not $tests ) {
	print "1..1\nnot ok 1\n";
	exit;
    }

    print "1..$tests\n";

    my $counter = 1;
    while ( 1 ) {
	my $t = shift @TESTS;
	my $m = shift @MESSAGES;
	if( not $t ) {
	    print "not ";
	}
	print "ok $counter\n";

	if( $m ) { 
	    print "[$counter] $m\n";
	}
	last if not scalar @TESTS;
	$counter ++;
    }
}
