### -*- Mode: perl -*-
eval " use ReDIF::Parser::Input; ";

test( not( $@ ), $@ );

use ReDIF::Parser::Input;

my $r;

$r = ReDIF::Parser::Input::start_file( 't/ctlseri.rdf', 0 );

test($r);

for( my $in=0; $in < 8 ; $in ++ ) {
    $r = ReDIF::Parser::Input::extract_next_line( );
}

$line = ReDIF::Parser::Input::get_the_line( );

test( $line, $line );

###
### now need to test input from a certain position in file
###

#  first we open the file, and read several lines from there. Then we
#  remember the position in file after these operations.  Then we
#  start Input::start_file() with that position, and see what turns
#  out.

my $fourth_line_position = 0 ;

# {
#     open SEEKTEST, "<t/ctlseri.rdf" ;
#     my $l; 
#     $l = <SEEKTEST>; 
#     $l = <SEEKTEST>; 
#     $l = <SEEKTEST>; 
#     test( ( $l =~ /^Provider\-name:/ ) , $l );
# 
#     $fourth_line_position = tell( SEEKTEST );
#     close SEEKTEST;
# }


###  after using binmode() in Parser::Input the above is no longer needed...


$fourth_line_position = 114 ;


#  now we create a dumb output object to track things down and
#  configure Input to use it:

{ 
    package data_collector;  
    
    sub new { 
        my $class = shift;
	my $self = { data => [] };
	bless $self, $class;
	return $self;
    };  # 


    sub add_data { 
 	my $self = shift;
	my $data = shift;
	my $data_array = $self->{data};
	push @$data_array, $data;
    };

    sub flush_data_buffer {};

    use vars qw( $attribute $value );

    sub the_attribute {
	my ( $p, $a, $v, $pos, $ln ) = @_;
	$attribute = $a;
	$value = $v;
    }

    sub attribute { $attribute };
    sub value     { $value };

}

my $data_collector = data_collector -> new();

ReDIF::Parser::Input::init( { output_source => $data_collector ,
			      attribute_output => $data_collector } );


###  now open the file

$r = ReDIF::Parser::Input::start_file( 't/ctlseri.rdf', $fourth_line_position );

test( $r, "line position: $fourth_line_position" );

###  read one attribute ...

$r = ReDIF::Parser::Input::extract_next_attribute();

###  the tests

test( $r );
test( $data_collector->attribute );
test( ( $data_collector->attribute eq 'maintainer-name' ), $data_collector->attribute );


my $data = $data_collector -> {data};

test( scalar ( @$data ), join( "\n" , "DATA:" , @$data, ":END_OF_DATA" ) );
      
# if( $r ) {
#    print $r->{attribute}, "\n";
#    print $r->{value}, "\n";
#    print $r->{file_position}, "\n";
#    print $r->{line_number}, "\n";
#    print join( "\n" , "DATA:" , @$data, ":END_OF_DATA" ) ;
# }






###############################################################
#############     TESTING   FRAMEWORK     #####################
###############################################################

sub test {
    push @TESTS, shift;
    push @MESSAGES, shift;
}

sub ok { 
    push @TESTS, 1; 
    push @MESSAGES, shift;
}
sub nok { 
    push @TESTS, 0; 
    push @MESSAGES, shift;
}



END { 

    my $tests = scalar @TESTS;

    if( not $tests ) {
	print "1..1\nnot ok 1\n";
	exit;
    }

    print "1..$tests\n";

    my $counter = 1;
    while ( 1 ) {
	my $t = shift @TESTS;
	my $m = shift @MESSAGES;
	if( not $t ) {
	    print "not ";
	}
	print "ok $counter\n";

	if( $m ) { 
	    print "[$counter] $m\n";
	}
	last if not scalar @TESTS;
	$counter ++;
    }
}
