### -*- Mode: perl -*-

BEGIN { 
#	push @ARGV, '--spec' , './spec'; 
}

sub test ($;$);

use ReDIF::Parser;
my $t;

$t = ReDIF::Parser::open_file( "t/single_bad_template.rdf" );

test( $t, "open_file" );

$t = ReDIF::Parser::get_next_template_good_or_bad() ;

test( $t, "get_next_template_good_or_bad" );

test ( $t -> {handle} [0] eq 'RePEc:cep:cepdps:0060' ) ;
test ( $t -> {ERRORS} );

$t = ReDIF::Parser::get_next_template_good_or_bad() ;

test( not($t), "get_next_template_good_or_bad" );


$t = ReDIF::Parser::open_file( "t/single_bad_template2.rdf" );

test( $t, "open_file" );

$t = ReDIF::Parser::get_next_template_good_or_bad() ;

test( $t, "get_next_template_good_or_bad" );

test ( $t -> {handle} [0] eq 'RePEc:cep:cepdps:0060' ) ;
test ( $t -> {ERRORS} );


###############################################################
#############     TESTING   FRAMEWORK     #####################
###############################################################

sub test ($;$) {
    push @TESTS, shift;
    push @MESSAGES, shift;
}

sub ok { 
    push @TESTS, 1; 
    push @MESSAGES, shift;
}
sub nok { 
    push @TESTS, 0; 
    push @MESSAGES, shift;
}



END { 

    my $tests = scalar @TESTS;

    if( not $tests ) {
	print "1..1\nnot ok 1\n";
	exit;
    }

    print "1..$tests\n";

    my $counter = 1;
    while ( 1 ) {
	my $t = shift @TESTS;
	my $m = shift @MESSAGES;
	if( not $t ) {
	    print "not ";
	}
	print "ok $counter\n";

	if( $m ) { 
	    print "[$counter] $m\n";
	}
	last if not scalar @TESTS;
	$counter ++;
    }
}
