### -*- Mode: perl -*-

BEGIN { 
#	push @ARGV, '--spec' , './spec'; 
}

use ReDIF::Parser;

open ( IN, "<t/test.rdf" );
read ( IN, $data, 60000 );
close( IN );

my $t;

$t = ReDIF::Parser::parse_string( $data );

test( $t );

$t = ReDIF::Parser::get_next_template_good_or_bad();

test( $t );

test( $t->{RESULT} eq 'good', $t->{RESULT} );

my $last_t;
my $c = 0;
while( $t ) {
    $last_t = $t;
    $t = ReDIF::Parser::get_next_template_good_or_bad();
    $c++;
}

# use Data::Dumper;
# print Dumper( $last_t );

test( $last_t->{RESULT} );

test( $last_t->{RESULT} eq 'good' );

test( ( $c == 4 )? 1: 0 , $c );


####  parse a file from non-zero position

$t = ReDIF::Parser::open_file( "t/test3.rdf", 0x537 );

test( $t, "positioned open_file failed" );

$t = ReDIF::Parser::get_next_template_good_or_bad() ;

test( $t, "get_next_template after positioned open failed" );

$t = ( $t -> {handle} [0] eq 'RePEc:cep:cepwps' ) ;

test( $t, "wrong or incomplete template" );


### 2002-10-24 00:11 Recently Sune reported a bug, where the parser
### (the Core) didn't clear out the error/warning counters after a
### very bad ReDIF file.  Need to check that:

ReDIF::Parser::open_file( "t/parser.t" );

$t = ReDIF::Parser::redif_get_next_template_good_or_bad() ;

test( not $t );

ReDIF::Parser::open_file( "t/test.rdf" );

$t = ReDIF::Parser::redif_get_next_template_good_or_bad() ;

test( not $t->{ERRORS} );
test( not $t->{WARNINGS} );

if( $t ) {
    print "file $t->{FILENAME}\n";
    print "PROBLEMS: $t->{PROBLEMS}\n";
    print "REPORT: $t->{REPORT}\n";
    print "MESSAGES: $t->{MESSAGES}\n";
    print "ERRORS: $t->{ERRORS}\n";
    print "WARNINGS: $t->{WARNINGS}\n";
}





###############################################################
#############     TESTING   FRAMEWORK     #####################
###############################################################

sub test {
    push @TESTS, shift;
    push @MESSAGES, shift;
}

sub ok { 
    push @TESTS, 1; 
    push @MESSAGES, shift;
}
sub nok { 
    push @TESTS, 0; 
    push @MESSAGES, shift;
}



END { 

    my $tests = scalar @TESTS;

    if( not $tests ) {
	print "1..1\nnot ok 1\n";
	exit;
    }

    print "1..$tests\n";

    my $counter = 1;
    while ( 1 ) {
	my $t = shift @TESTS;
	my $m = shift @MESSAGES;
	if( not $t ) {
	    print "not ";
	}
	print "ok $counter\n";

	if( $m ) { 
	    print "[$counter] $m\n";
	}
	last if not scalar @TESTS;
	$counter ++;
    }
}
