### -*- Mode: perl -*-

use ReDIF::Parser;

###  

BEGIN {
    if( not ReDIF::Parser::calculate_md5_checksum ) {
	print "1..0   # Skip MD5 checksum calculation is inavailable or disabled\n" ;
	exit;
    } 
}

use Test;
use strict;


BEGIN { plan tests => 5 }

print ">>t/1995.rdf\n";
ReDIF::Parser::open_file( 't/1995.rdf' );

my $t = ReDIF::Parser::get_next_template();

ok( $t->{MD5SUM} ) ;

ok( $t->{MD5SUM}, 'XgP5KMNMowS7nMVPeQcp1Q' );


print ">>t/1995.rdf -- second template\n";

$t = ReDIF::Parser::get_next_template();

print "$t->{handle}[0]: $t->{MD5SUM}\n";

my $save = {
    file => $t->{FILENAME},
    startfpos => $t->{STARTFPOS},
    md5sum => $t -> {MD5SUM},
    handle => $t->{handle}[0],
};


ReDIF::Parser::open_file( 't/dp0060.rdf' );

$t = ReDIF::Parser::get_next_template();

print "dp0060: $t->{MD5SUM}\n";

ok( $t->{MD5SUM}, 'c/m2/V8DLmvUKKDM+hO4pA' );


ReDIF::Parser::open_file( $save->{file}, $save->{startfpos} );

$t = ReDIF::Parser::get_next_template();

ok( $t->{handle}[0], $save->{handle} );
ok( $t->{MD5SUM},    $save->{md5sum} );







