use ExtUtils::MakeMaker;

sub configure {
  print "Preparing to install ReDIF perl package.\n";
  do ( "Configure" ) 
    or die "Configure failed, so do I";
  eval { require 5.008_000 };
  if ( $@ ) {
    die "You need at least perl 5.8 to use this version of ReDIF-perl\n";
  }  
}

if(not $ENV{MAKEMAKEFILE}) { configure(); }

WriteMakefile(
              NAME      => 'ReDIF-perl',
              'PREREQ_PM' => {
                              'Text::LevenshteinXS' => 0,
                              'Carp::Assert' => 0
                             },
              'PREREQ_FATAL' => 1,
              VERSION => '2.65',
              'EXE_FILES' => [ 'rech', 'rere', 'updateJEL.pl' ],
              'dist'      => {
                  TARFLAGS => '-cvf',
                  COMPRESS => 'gzip -9f',
                  SUFFIX   => '.gz',
              },

);
