use strict;
use Net::Daemon;
use Net::Daemon::Log;
use IO::File;
use IO::Socket::UNIX;
use Proc::Daemon;
use ACIS::Resources::Learn::Suggested;
## schmorp
#use Storable qw(thaw); 
use Common::Data;
##

package Learn;

# cardiff

# not fit to be run with -w 

my $socket_file="$homedir/learning_socket";
my $log_file="$homedir/opt/log/learning_daemon.log";
my $pid_file="$homedir/opt/learning_daemon.pid";

# find user name from home dir
my $user=$homedir;
$user=~s|/home/([^/]+)/.*|$1|;

use vars qw($VERSION @ISA);
$VERSION = '0.01';
@ISA = qw(Net::Daemon); # to inherit from Net::Daemon


sub Version ($) { 'ACIS Learning Server'; }

Proc::Daemon::Init;

# Treat command line option in the constructor
sub new ($$;$) {
  my($class, $attr, $args) = @_;
  my($self) = $class->SUPER::new($attr, $args);
  #$self->{'facility'} = 'mail'; # Default: Daemon
  # Choose logging method: IO handle
  my $file = IO::File->new($log_file, "a");
  $self->{'logfile'} = $file;
  print $file "started log daemon at ".`date`;
  $self->Debug('Start at'.`date`);
  return $self;
}

sub Run ($) {
  my($self)=@_;
  my $socket = $self->{'socket'};
  ## schmorp
  my $debug=0;
  $self->Log("\nlearning invoked");  
  my $length = $socket->getline();
  chomp($length);
  my $buffer = '';
  while(length $buffer < $length 
        ## $socket is io::socket, inherits from io::handle, has eof function
        ## described in perlfunc
        and not $socket->eof()) {
    ## append to buffer
    $buffer=$buffer.$socket->getline();
  }
  #while(not $last and defined($line=$socket->getline())) {
  #  #print "line is |$line|\n";
  #  if($line eq ".\n") {
  #    #print "last\n";
  #   $last=1;
  #  }
  #  else {
  #    $learner.=$line;
  #  }
  #}
  #if($@) {
  #  $self->Error("an error: $@");
  #}
  #$learner=Storable::thaw($learner);
  #my $error=$@;
  #if($error) {
  #  warn $error;
  #}
  my $learner=&Common::Data::inflate($buffer);
  ## /schmorp
  ACIS::Resources::Learn::Suggested::learn_suggested($learner);
  if($debug) {
    my $dumped=Data::Dumper::Dumper($learner);
    $self->Log("\nLearner\n\n: $dumped");  
  }
  return;
}


package main;
my $server = Learn->new({'pidfile' => $pid_file,
                         'facility' => 'daemon',
                         'localpath' => $socket_file,
                         'user'=> $user,
                         'group'=> $user,
                         'mode'=>'fork'
                        },                       
                      \@ARGV);
$server->Bind() or die ;



